<?php

namespace Services\dtos;

class CommentDto
{
    public readonly int $id;
    public readonly string $user_name;
    public readonly bool $is_admin;
    public string $content;
    public string $date;
    public readonly int $parent_id;

    /* @var CommentDto[] $children */
    public array $children;

    public ?int $rate;

    public function __construct(string $id, string $user_name, bool $is_admin, string $content, string $date, int $parent_id)
    {
        $this->id = $id;
        $this->user_name = $is_admin ? get_bloginfo('name') : $user_name;
        $this->is_admin = $is_admin;
        $this->content = $is_admin ? $content : esc_textarea($content);
        $this->date = $date;
        $this->parent_id = $parent_id;
        $this->children = [];
        $this->rate = null;
    }
}