<?php

namespace Services\dtos;

class IconDto
{
    public readonly string $svg_content;


    public function __construct($svg_content)
    {
        $this->svg_content = $svg_content;
    }

    public static function build($id): IconDto
    {
        $file_path = get_attached_file($id);
        $content = '';

        if ($file_path && file_exists($file_path)) {
            $content = file_get_contents($file_path);
            $content = $content ?: '';
        }

        return new self($content);
    }
}