<?php

namespace Services\dtos;

class ImageDto
{
    public readonly string $src;
    public readonly string $alt;


    public function __construct($src, $alt)
    {
        $this->src = $src;
        $this->alt = $alt;
    }

    public static function build($id, $size, $default_alt): ImageDto
    {
        $src = wp_get_attachment_image_src($id, $size)[0];
        $alt = get_post_meta($id, '_wp_attachment_image_alt', true);
        $alt = $alt ?: $default_alt;
        return new self($src, $alt);
    }
}