<?php

namespace Services\dtos;

class MenuItemDto
{
    public string $id;
    public string $parent_id;

    public readonly string $title;
    public readonly string $url;
    public readonly ?IconDto $icon;

    /* @var MenuItemDto[] $children */
    public array $children;


    public function __construct(string $id, string $parent_id, string $title, string $url, ?IconDto $icon = null)
    {
        $this->id = $id;
        $this->parent_id = $parent_id;
        $this->title = $title;
        $this->url = $url;
        $this->icon = $icon;
        $this->children = [];
    }

    public function addChild(MenuItemDto $child) : void
    {
        $this->children[] = $child;
    }
}