<?php

namespace Services\dtos;

class ProductDetailsDto
{
    public readonly string $title;
    public readonly ?ImageDto $image;
    /** @var ImageDto[] */
    public readonly array $gallery;
    public readonly string $category;
    public readonly string $short_desc_attr;
    public readonly bool $in_stock;
    public readonly string $full_desc;
    public readonly float $regular_price;
    public readonly float $sale_price;
    public readonly float $discount;
    public readonly string $link;

    /** @var AttributeDto[] $attributes */
    public readonly array $attributes;

    /* @var VariationDto[] $variations */
    public readonly array $variations;

    public readonly int $min_quantity;
    public readonly int $max_quantity;

    public function __construct(
        string $title,
        ?ImageDto $image,
        array $gallery,
        string $category,
        string $short_desc_attr,
        bool $in_stock,
        string $full_desc,
        float $regular_price,
        float $sale_price,
        string $link,
        array $attributes,
        array $variations,
        int $min_quantity,
        int $max_quantity
    ) {
        $this->title = $title;
        $this->image = $image;
        $this->gallery = $gallery;
        $this->category = $category;
        $this->short_desc_attr = $short_desc_attr;
        $this->in_stock = $in_stock;
        $this->full_desc = $full_desc;
        $this->regular_price = $regular_price;
        $this->sale_price = $sale_price;
        $this->link = $link;
        $this->attributes = $attributes;
        $this->variations = $variations;

        $discount = $regular_price > 0 ? (($regular_price - $sale_price) / $regular_price) * 100 : 0;
        $discount = floatval(number_format($discount, 1));
        $this->discount = $discount;

        $this->min_quantity = $min_quantity;
        $this->max_quantity = $max_quantity;
    }
}