<?php

namespace Services\dtos;

class ProductDto
{
    public readonly int $id;
    public readonly string $title;
    public readonly ?ImageDto $image;
    public readonly string $link;
    public readonly string $category;
    public readonly float $regular_price;
    public readonly float $sale_price;
    public readonly float $discount;

    public readonly int $min_quantity;
    public readonly int $max_quantity;

    public function __construct(int   $id, string $title, ?ImageDto $image, string $link, string $category,
                                float $regular_price, float $sale_price, int $min_quantity, int $max_quantity)
    {
        $this->id = $id;
        $this->title = $title;
        $this->image = $image;
        $this->link = $link;
        $this->category = $category;
        $this->regular_price = $regular_price;
        $this->sale_price = $sale_price;

        $discount = $regular_price > 0 ? (($regular_price - $sale_price) / $regular_price) * 100 : 0;
        $discount = floatval(number_format($discount, 1));
        $this->discount = $discount;

        $this->min_quantity = $min_quantity;
        $this->max_quantity = $max_quantity;
    }
}