<?php

namespace services\dtos;

class VariationDto
{
    public readonly string $id;
    public readonly float $sale_price;
    public readonly float $regular_price;
	public readonly float $discount;
    public readonly bool $in_stock;

    /* @var FilterDto[] $attributes */
    public readonly array $attributes;
    public readonly ImageDto $image;

    /* @param FilterDto[] $attributes */
    public function __construct(string $id, float $sale_price, float $regular_price, bool $in_stock, array $attributes, ?ImageDto $image)
    {
        $this->id = $id;
        $this->sale_price = $sale_price;
        $this->regular_price = $regular_price;
        $this->in_stock = $in_stock;
        $this->attributes = $attributes;
        $this->image = $image;

	    $discount = $regular_price > 0 ? (($regular_price - $sale_price) / $regular_price) * 100 : 0;
	    $discount = floatval(number_format($discount, 1));
	    $this->discount = $discount;
    }
}