<?php

namespace Services\enums;

enum SocialLinkType: string
{
    case Instagram = 'Instagram';
    case Telegram = 'Telegram';
    case WhatsApp = 'WhatsApp';

    public function get_logo_name(bool $fill = false): string
    {
        switch ($this) {
            case SocialLinkType::Instagram:
                if ($fill) return 'instagram-logo-fill';
                return 'instagram-logo';
            case SocialLinkType::Telegram:
                if ($fill) return 'telegram-logo-fill';
                return 'telegram-logo';
            case SocialLinkType::WhatsApp:
                if ($fill) return 'whatsapp-logo-fill';
                return 'whatsapp-logo';
        }
        return '';
    }

    public function get_color(bool $light = false): string
    {
        switch ($this) {
            case SocialLinkType::Instagram:
                if ($light) return '#FEF2F2';
                return '#EF4444';
            case SocialLinkType::Telegram:
                if ($light) return '#EFF6FF';
                return '#3B82F6';
            case SocialLinkType::WhatsApp:
                if ($light) return '#F0FDF4';
                return '#16A34A';
        }
        return '';
    }
}