<?php

namespace Services\enums;

use Services\dtos\FilterDto;

enum SortType: string
{
    case Popularity = 'popular';
    case Date = 'date'; // Sort by latest
    case PriceAsc = 'cheap'; // Sort by price: low to high
    case PriceDesc = 'expensive'; // Sort by price: high to low

    function get_display(): string
    {
        switch ($this) {
            case SortType::Popularity:
                return 'محبوب‌ترین';
            case SortType::Date:
                return 'جدیدترین';
            case SortType::PriceDesc:
                return 'گران‌ترین';
            case SortType::PriceAsc:
                return 'ارزا ن‌ترین';
        }

        return '';
    }

    function get_filter(): FilterDto
    {
        return new FilterDto('sort', $this->value, $this->get_display());
    }
}